Option Explicit

Dim oShell
Dim windir
Dim msg
Dim msgTmp

Set oShell = CreateObject("WScript.Shell")

windir = oShell.ExpandEnvironmentStrings( "%SystemRoot%" )

On Error Resume Next

msg = "MxLoader WebLogin troubleshooting script" & vbCrLf

' Read the registry for the operating system version
msg = msg & vbCrLf & "OS"
msg = msg & vbCrLf & "ProductName = " & oShell.RegRead("HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\ProductName")
msg = msg & vbCrLf & "SystemRoot = " & oShell.RegRead("HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SystemRoot")
msg = msg & vbCrLf & "CPU = " & oShell.RegRead("HKLM\HARDWARE\DESCRIPTION\System\CentralProcessor\0\Identifier")
msg = msg & vbCrLf & "BIT = " & oShell.RegRead("HKLM\HARDWARE\DESCRIPTION\System\CentralProcessor\0\Platform ID")

msg = msg & vbCrLf
msg = msg & vbCrLf & ".NET"
msg = msg & vbCrLf & "Release=" & oShell.RegRead("HKLM\SOFTWARE\Microsoft\NET Framework Setup\NDP\v4\Full\Release")
msg = msg & vbCrLf & "Release=" & CheckFor45PlusVersion(oShell.RegRead("HKLM\SOFTWARE\Microsoft\NET Framework Setup\NDP\v4\Full\Release"))

msg = msg & vbCrLf
msg = msg & vbCrLf & "Office"
msg = msg & vbCrLf & "CurVer=" & oShell.RegRead("HKCR\Excel.Application\CurVer\")

msg = msg & vbCrLf
msg = msg & vbCrLf & "WebLogin"
msg = msg & vbCrLf & "CLSID=" & oShell.RegRead("HKCR\WebLogin.WebLoginForm\CLSID\")
msg = msg & vbCrLf & CheckFile(windir &"\system32\WebLogin.dll")
msg = msg & vbCrLf & CheckFile(windir &"\system32\WebLogin.dll")
msg = msg & vbCrLf & CheckFile(windir &"\SysWOW64\WebLogin.dll")
msg = msg & vbCrLf & CheckFile(windir &"\SysWOW64\WebLogin.tlb")


MsgBox msg


Function CheckFor45PlusVersion(releaseKey)
      CheckFor45PlusVersion = "No 4.5 or later version detected"
      
      If releaseKey >= 394802 Then
         CheckFor45PlusVersion = "4.6.2 or later"
      ElseIf releaseKey >= 394254 Then
         CheckFor45PlusVersion = "4.6.1"
      ElseIf releaseKey >= 393295 Then
         CheckFor45PlusVersion = "4.6"
      ElseIf releaseKey >= 379893 Then
         CheckFor45PlusVersion = "4.5.2"
      ElseIf releaseKey >= 378675 Then
         CheckFor45PlusVersion = "4.5.1"
      ElseIf releaseKey >= 378389 Then
        CheckFor45PlusVersion = "4.5"
      End If
End Function

Function CheckFile(fileName)
    dim fso
    Set fso = CreateObject("Scripting.FileSystemObject")
    
    If (fso.FileExists(fileName)) Then
       CheckFile = fileName & " found"
    Else
       CheckFile = fileName & " not found"
    End If
End Function
